/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.function.IntFunction;
import net.minecraft.ChatFormatting;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;

public record ChatTypeDecoration(String translationKey, List<Parameter> parameters, Style style) {
    public static final Codec<ChatTypeDecoration> CODEC = RecordCodecBuilder.create(p_304159_ -> p_304159_.group((App)Codec.STRING.fieldOf("translation_key").forGetter(ChatTypeDecoration::translationKey), (App)Parameter.CODEC.listOf().fieldOf("parameters").forGetter(ChatTypeDecoration::parameters), (App)Style.Serializer.CODEC.optionalFieldOf("style", (Object)Style.EMPTY).forGetter(ChatTypeDecoration::style)).apply((Applicative)p_304159_, ChatTypeDecoration::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatTypeDecoration> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.STRING_UTF8, ChatTypeDecoration::translationKey, Parameter.STREAM_CODEC.apply(ByteBufCodecs.list()), ChatTypeDecoration::parameters, Style.Serializer.TRUSTED_STREAM_CODEC, ChatTypeDecoration::style, ChatTypeDecoration::new);

    public static ChatTypeDecoration withSender(String p_239223_) {
        return new ChatTypeDecoration(p_239223_, List.of(Parameter.SENDER, Parameter.CONTENT), Style.EMPTY);
    }

    public static ChatTypeDecoration incomingDirectMessage(String p_239425_) {
        Style $$1 = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true);
        return new ChatTypeDecoration(p_239425_, List.of(Parameter.SENDER, Parameter.CONTENT), $$1);
    }

    public static ChatTypeDecoration outgoingDirectMessage(String p_240772_) {
        Style $$1 = Style.EMPTY.withColor(ChatFormatting.GRAY).withItalic(true);
        return new ChatTypeDecoration(p_240772_, List.of(Parameter.TARGET, Parameter.CONTENT), $$1);
    }

    public static ChatTypeDecoration teamMessage(String p_239095_) {
        return new ChatTypeDecoration(p_239095_, List.of(Parameter.TARGET, Parameter.SENDER, Parameter.CONTENT), Style.EMPTY);
    }

    public Component decorate(Component p_241301_, ChatType.Bound p_241391_) {
        Object[] $$2 = this.resolveParameters(p_241301_, p_241391_);
        return Component.translatable(this.translationKey, $$2).withStyle(this.style);
    }

    private Component[] resolveParameters(Component p_241365_, ChatType.Bound p_241559_) {
        Component[] $$2 = new Component[this.parameters.size()];
        for (int $$3 = 0; $$3 < $$2.length; ++$$3) {
            Parameter $$4 = this.parameters.get($$3);
            $$2[$$3] = $$4.select(p_241365_, p_241559_);
        }
        return $$2;
    }

    public static enum Parameter implements StringRepresentable
    {
        SENDER(0, "sender", (p_241238_, p_241239_) -> p_241239_.name()),
        TARGET(1, "target", (p_321399_, p_321400_) -> p_321400_.targetName().orElse(CommonComponents.EMPTY)),
        CONTENT(2, "content", (p_239974_, p_241427_) -> p_239974_);

        private static final IntFunction<Parameter> BY_ID;
        public static final Codec<Parameter> CODEC;
        public static final StreamCodec<ByteBuf, Parameter> STREAM_CODEC;
        private final int id;
        private final String name;
        private final Selector selector;

        private Parameter(int p_348493_, String p_239588_, Selector p_239589_) {
            this.id = p_348493_;
            this.name = p_239588_;
            this.selector = p_239589_;
        }

        public Component select(Component p_241369_, ChatType.Bound p_241509_) {
            return this.selector.select(p_241369_, p_241509_);
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        static {
            BY_ID = ByIdMap.continuous(p_348119_ -> p_348119_.id, Parameter.values(), ByIdMap.OutOfBoundsStrategy.ZERO);
            CODEC = StringRepresentable.fromEnum(Parameter::values);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, p_348120_ -> p_348120_.id);
        }

        public static interface Selector {
            public Component select(Component var1, ChatType.Bound var2);
        }
    }
}

